/******************************************************************************
 * main.h - Initialisation de la fenetre OpenGL                               *
 ******************************************************************************
 * Projet       : Code(R) - Sphere                                            *
 * Auteur       : Arnaud Storq (http://norecess.planet-d.net)/Posse-Press 2004*
 ******************************************************************************/
#ifndef _MAIN_
#define _MAIN_

//---------------------------------------------------------------------------- CONSTANTES
// Titre de la fenetre
#define TITRE_FENETRE "Exemple d'un effet \"Render-To-Texture\""

// Rsolution de la fenetre OpenGL
#define RESOLUTION_LARGEUR                  512
#define RESOLUTION_HAUTEUR                  512

// Rsolution de la texture de rendu
// ATTENTION !! Ces valeurs doivent imperativement etre des puissances de 2 (512, 256, 128..)
// et etre INFERIEUR  la resolution de la fenetre OpenGL
// Si la texture de rendu etait plus large que celle de la fenetre principale,
// il y aurait des debordements d'affichages inattendu !
#define RESOLUTION_RENDERTEXTURE_LARGEUR    512
#define RESOLUTION_RENDERTEXTURE_HAUTEUR    512

// La texture  appliquer sur la sphere
// ATTENTION !! Seul le format .TGA est possible !
#define FICHIER_TEXTURE                     "texture.tga"

// Attributs de la sphere
#define SPHERE_MOUVEMENT_X                  0.15f
#define SPHERE_MOUVEMENT_Y                  0.15f
#define SPHERE_ROTATION_VITESSE             0.05f

// Nombre de points composants la sphere. Plus il y en aura, plus le rendu de la sphere sera precis !
#define SPHERE_NB_POINTS_HORIZONTAL         64
#define SPHERE_NB_POINTS_VERTICAL           64

// Taille de la sphere
// 1.0f represente une sphere dont les bords touchent pile-poil les bords de la fenetre.
#define SPHERE_TAILLE                       0.8f

// Attributs de l'affichage de la texture de rendu
// L'algorythme utilis est 
// for (float zoom = ZOOM_DEBUT; zoom < ZOOM_FIN; zoom += ZOOM_INCREMENT )
// Ainsi, si l'on remplace 0.02f par 0.01f, il y aura deux fois plus de traines affiches !!
// Attention  la baisse de framerate :)
#define ZOOM_DEBUT                          1.0f
#define ZOOM_FIN                            1.6f
#define ZOOM_INCREMENT                      0.02f

//---------------------------------------------------------------------------- FIN DE DECLARATION
#endif // _MAIN_

